
CREATE TABLE utenti (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL
);

CREATE TABLE prodotti_primari (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(100) NOT NULL,
    categoria ENUM('Aroma', 'PG', 'Tappo', 'Bottiglia', 'Etichetta', 'Cartoncino', 'Sigillo trasparente', 'Sigillo del monopolio') NOT NULL,
    unita_misura ENUM('g', 'pz') NOT NULL,
    giacenza DECIMAL(10,2) DEFAULT 0
);

CREATE TABLE prodotti_composti (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(100) NOT NULL,
    ancoraggio VARCHAR(100),
    tipologia VARCHAR(100),
    lotto VARCHAR(50),
    data_produzione DATE
);

CREATE TABLE ricette (
    id INT AUTO_INCREMENT PRIMARY KEY,
    prodotto_composto_id INT,
    prodotto_primario_id INT,
    quantita DECIMAL(10,2),
    FOREIGN KEY (prodotto_composto_id) REFERENCES prodotti_composti(id),
    FOREIGN KEY (prodotto_primario_id) REFERENCES prodotti_primari(id)
);

CREATE TABLE movimenti (
    id INT AUTO_INCREMENT PRIMARY KEY,
    prodotto_id INT,
    tipo ENUM('carico', 'scarico') NOT NULL,
    quantita DECIMAL(10,2),
    data_operazione DATE,
    note TEXT,
    FOREIGN KEY (prodotto_id) REFERENCES prodotti_primari(id)
);
