
<?php
require_once __DIR__ . '/../config/config.php';
session_start();

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

$composti = $pdo->query("SELECT * FROM prodotti_composti ORDER BY nome")->fetchAll(PDO::FETCH_ASSOC);
$primari = $pdo->query("SELECT * FROM prodotti_primari ORDER BY nome")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['composto_id'], $_POST['primario_id'], $_POST['quantita'])) {
    $stmt = $pdo->prepare("INSERT INTO ricette (prodotto_composto_id, prodotto_primario_id, quantita) VALUES (?, ?, ?)");
    $stmt->execute([$_POST['composto_id'], $_POST['primario_id'], $_POST['quantita']]);
    header("Location: ricette.php");
    exit;
}

$ricette = $pdo->query("SELECT r.*, pc.nome AS composto, pp.nome AS primario 
    FROM ricette r 
    JOIN prodotti_composti pc ON pc.id = r.prodotto_composto_id 
    JOIN prodotti_primari pp ON pp.id = r.prodotto_primario_id 
    ORDER BY composto")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Gestione Ricette</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<header>
    <h1>Vape Balance Software</h1>
</header>
<nav>
    <a href="dashboard.php">Dashboard</a>
    <a href="prodotti_primari.php">Prodotti Primari</a>
    <a href="prodotti_composti.php">Prodotti Composti</a>
    <a href="carico.php">Carico</a>
    <a href="scarico.php">Scarico</a>
    <a href="report.php">Report</a>
    <a href="logout.php">Logout</a>
</nav>
<div class="container">
    <h2>Gestione Ricette</h2>
    <form method="POST">
        <label>Prodotto Composto:
            <select name="composto_id">
                <?php foreach ($composti as $c): ?>
                    <option value="<?= $c['id'] ?>"><?= $c['nome'] ?></option>
                <?php endforeach; ?>
            </select>
        </label>
        <label>Prodotto Primario:
            <select name="primario_id">
                <?php foreach ($primari as $p): ?>
                    <option value="<?= $p['id'] ?>"><?= $p['nome'] ?></option>
                <?php endforeach; ?>
            </select>
        </label>
        <label>Quantità: <input type="number" step="0.01" name="quantita" required></label>
        <button type="submit">Aggiungi</button>
    </form>
    <hr>
    <h3>Ricette esistenti</h3>
    <table border="1" cellpadding="5">
        <tr><th>Prodotto Composto</th><th>Prodotto Primario</th><th>Quantità</th></tr>
        <?php foreach ($ricette as $r): ?>
            <tr>
                <td><?= $r['composto'] ?></td>
                <td><?= $r['primario'] ?></td>
                <td><?= $r['quantita'] ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
