
<?php
require_once __DIR__ . '/../config/config.php';
require_once '../includes/fpdf.php';

session_start();
if (!isset($_SESSION['user'])) {
    die("Accesso non autorizzato");
}

require('fpdf.php');
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, 'Registro Giornaliero - ' . date('d/m/Y'), 0, 1, 'C');
$pdf->Ln(10);

$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(20, 8, 'ID', 1);
$pdf->Cell(50, 8, 'Prodotto', 1);
$pdf->Cell(20, 8, 'Tipo', 1);
$pdf->Cell(30, 8, 'Quantità', 1);
$pdf->Cell(40, 8, 'Data', 1);
$pdf->Cell(30, 8, 'Note', 1);
$pdf->Ln();

$stmt = $pdo->prepare("SELECT m.id, p.nome AS prodotto, m.tipo, m.quantita, m.data_operazione, m.note
                       FROM movimenti m
                       JOIN prodotti_primari p ON p.id = m.prodotto_id
                       WHERE m.data_operazione = CURDATE()");
$stmt->execute();
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

$pdf->SetFont('Arial', '', 10);
foreach ($data as $row) {
    $pdf->Cell(20, 8, $row['id'], 1);
    $pdf->Cell(50, 8, $row['prodotto'], 1);
    $pdf->Cell(20, 8, $row['tipo'], 1);
    $pdf->Cell(30, 8, $row['quantita'], 1);
    $pdf->Cell(40, 8, $row['data_operazione'], 1);
    $pdf->Cell(30, 8, $row['note'], 1);
    $pdf->Ln();
}

$pdf->Output('D', 'registro_' . date('Ymd') . '.pdf');
?>
