
<?php
require_once __DIR__ . '/../config/config.php';
session_start();

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

$composti = $pdo->query("SELECT * FROM prodotti_composti ORDER BY nome")->fetchAll(PDO::FETCH_ASSOC);
$messaggio = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['composto_id'], $_POST['quantita'])) {
    $id_composto = $_POST['composto_id'];
    $quantita = $_POST['quantita'];

    // Lancia produzione
    lanciaProduzione($id_composto, $quantita);

    // Log produzione
    $messaggio = "Produzione eseguita con successo. Scaricate automaticamente le materie prime.";

    // TODO: Genera e salva PDF ricetta (implementazione futura)
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Lancio Produzione</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<header>
    <h1>Vape Balance Software</h1>
</header>
<nav>
    <a href="dashboard.php">Dashboard</a>
    <a href="prodotti_primari.php">Prodotti Primari</a>
    <a href="prodotti_composti.php">Prodotti Composti</a>
    <a href="carico.php">Carico</a>
    <a href="scarico.php">Scarico</a>
    <a href="ricette.php">Ricette</a>
    <a href="produzione.php">Produzione</a>
    <a href="report.php">Report</a>
    <a href="logout.php">Logout</a>
</nav>
<div class="container">
    <h2>Lancio Produzione</h2>
    <?php if ($messaggio): ?>
        <p style="color:green;"><strong><?= $messaggio ?></strong></p>
    <?php endif; ?>
    <form method="POST">
        <label>Prodotto Composto:
            <select name="composto_id">
                <?php foreach ($composti as $c): ?>
                    <option value="<?= $c['id'] ?>"><?= $c['nome'] ?></option>
                <?php endforeach; ?>
            </select>
        </label>
        <label>Quantità (pezzi): <input type="number" name="quantita" step="1" required></label>
        <button type="submit">Avvia Produzione</button>
    </form>
</div>
</body>
</html>
