
<?php
require_once __DIR__ . '/../config/config.php';
session_start();

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

// Aggiunta nuovo prodotto primario
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['nome'], $_POST['categoria'], $_POST['unita'], $_POST['prezzo'])) {
    $stmt = $pdo->prepare("INSERT INTO prodotti_primari (nome, categoria, unita_misura, prezzo_unitario) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_POST['nome'], $_POST['categoria'], $_POST['unita'], $_POST['prezzo']]);
    header("Location: prodotti_primari.php");
    exit;
}

// Caricamento lista prodotti
$prodotti = getGiacenze();
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Prodotti Primari</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<header>
    <h1>Vape Balance Software</h1>
</header>
<nav>
    <a href="dashboard.php">Dashboard</a>
    <a href="prodotti_primari.php">Prodotti Primari</a>
    <a href="prodotti_composti.php">Prodotti Composti</a>
    <a href="carico.php">Carico</a>
    <a href="scarico.php">Scarico</a>
    <a href="report.php">Report</a>
    <a href="logout.php">Logout</a>
</nav>
<div class="container">
    <h2>Prodotti Primari</h2>
    <form method="POST">
        <label>Nome: <input type="text" name="nome" required></label>
        <label>Categoria:
            <select name="categoria" required>
                <option>Aroma</option>
                <option>PG</option>
                <option>Tappo</option>
                <option>Bottiglia</option>
                <option>Etichetta</option>
                <option>Cartoncino</option>
                <option>Sigillo trasparente</option>
                <option>Sigillo del monopolio</option>
            </select>
        </label>
        <label>Unità di misura:
            <select name="unita" required>
                <option value="g">Grammi (g)</option>
                <option value="pz">Pezzi (pz)</option>
            </select>
        </label>
        <label>Prezzo unitario (€): <input type="number" name="prezzo" step="0.01" required></label>
        <button type="submit">Aggiungi</button>
    </form>
    <hr>
    <h3>Elenco prodotti</h3>
    <table border="1" cellpadding="5">
        <tr>
            <th>Nome</th><th>Categoria</th><th>Unità</th><th>Giacenza</th><th>Prezzo Unitario (€)</th>
        </tr>
        <?php foreach ($prodotti as $p): ?>
            <tr>
                <td><?= htmlspecialchars($p['nome']) ?></td>
                <td><?= $p['categoria'] ?></td>
                <td><?= $p['unita_misura'] ?></td>
                <td><?= $p['giacenza'] ?></td>
                <td><?= number_format($p['prezzo_unitario'], 2) ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
