
<?php
require_once __DIR__ . '/../config/config.php';
session_start();

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

// Aggiunta prodotto composto
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['nome'], $_POST['ancoraggio'], $_POST['tipologia'], $_POST['lotto'])) {
    $stmt = $pdo->prepare("INSERT INTO prodotti_composti (nome, ancoraggio, tipologia, lotto, data_produzione) VALUES (?, ?, ?, ?, CURDATE())");
    $stmt->execute([$_POST['nome'], $_POST['ancoraggio'], $_POST['tipologia'], $_POST['lotto']]);
    header("Location: prodotti_composti.php");
    exit;
}

// Recupera composti e calcola costo totale per ognuno
$composti = $pdo->query("SELECT * FROM prodotti_composti ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

function calcolaCosto($id_composto) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT SUM(r.quantita * p.prezzo_unitario) AS costo_totale
                           FROM ricette r
                           JOIN prodotti_primari p ON r.prodotto_primario_id = p.id
                           WHERE r.prodotto_composto_id = ?");
    $stmt->execute([$id_composto]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    return $row['costo_totale'] ?? 0;
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Prodotti Composti</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<header>
    <h1>Vape Balance Software</h1>
</header>
<nav>
    <a href="dashboard.php">Dashboard</a>
    <a href="prodotti_primari.php">Prodotti Primari</a>
    <a href="prodotti_composti.php">Prodotti Composti</a>
    <a href="carico.php">Carico</a>
    <a href="scarico.php">Scarico</a>
    <a href="report.php">Report</a>
    <a href="logout.php">Logout</a>
</nav>
<div class="container">
    <h2>Prodotti Composti</h2>
    <form method="POST">
        <label>Nome: <input type="text" name="nome" required></label>
        <label>Ancoraggio: <input type="text" name="ancoraggio" required></label>
        <label>Tipologia: <input type="text" name="tipologia" required></label>
        <label>Lotto: <input type="text" name="lotto" required></label>
        <button type="submit">Aggiungi</button>
    </form>
    <hr>
    <h3>Elenco prodotti composti</h3>
    <table border="1" cellpadding="5">
        <tr>
            <th>Nome</th><th>Ancoraggio</th><th>Tipologia</th><th>Lotto</th><th>Data</th><th>Costo Produzione (€)</th>
        </tr>
        <?php foreach ($composti as $c): ?>
            <tr>
                <td><?= htmlspecialchars($c['nome']) ?></td>
                <td><?= $c['ancoraggio'] ?></td>
                <td><?= $c['tipologia'] ?></td>
                <td><?= $c['lotto'] ?></td>
                <td><?= $c['data_produzione'] ?></td>
                <td><?= number_format(calcolaCosto($c['id']), 2) ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
