
<?php
require_once __DIR__ . '/../config/config.php';
session_start();

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

$utente = $_SESSION['user'];
$utente_dati = $pdo->prepare("SELECT * FROM utenti WHERE username = ?");
$utente_dati->execute([$utente]);
$utente_corrente = $utente_dati->fetch();

if ($utente_corrente['ruolo'] !== 'admin') {
    die("Accesso negato.");
}

// Aggiunta nuovo utente
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['username'], $_POST['password'], $_POST['ruolo'])) {
    $stmt = $pdo->prepare("INSERT INTO utenti (username, password, ruolo) VALUES (?, ?, ?)");
    $stmt->execute([$_POST['username'], md5($_POST['password']), $_POST['ruolo']]);
    header("Location: gestione_utenti.php");
    exit;
}

// Elimina utente
if (isset($_GET['elimina']) && $_GET['elimina'] !== $utente) {
    $stmt = $pdo->prepare("DELETE FROM utenti WHERE username = ?");
    $stmt->execute([$_GET['elimina']]);
    header("Location: gestione_utenti.php");
    exit;
}

$utenti = $pdo->query("SELECT * FROM utenti")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Gestione Utenti</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<header><h1>Gestione Utenti</h1></header>
<nav>
    <a href="dashboard.php">Dashboard</a>
    <a href="gestione_utenti.php">Gestione Utenti</a>
    <a href="logout.php">Logout</a>
</nav>
<div class="container">
    <h2>Aggiungi Utente</h2>
    <form method="POST">
        <label>Username: <input type="text" name="username" required></label>
        <label>Password: <input type="password" name="password" required></label>
        <label>Ruolo:
            <select name="ruolo">
                <option value="operatore">Operatore</option>
                <option value="admin">Admin</option>
            </select>
        </label>
        <button type="submit">Aggiungi</button>
    </form>
    <hr>
    <h3>Utenti Registrati</h3>
    <table border="1" cellpadding="5">
        <tr><th>Username</th><th>Ruolo</th><th>Azioni</th></tr>
        <?php foreach ($utenti as $u): ?>
            <tr>
                <td><?= $u['username'] ?></td>
                <td><?= $u['ruolo'] ?></td>
                <td>
                    <?php if ($u['username'] !== $utente): ?>
                        <a href="?elimina=<?= $u['username'] ?>" onclick="return confirm('Sei sicuro?')">Elimina</a>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
