
<?php
require_once __DIR__ . '/../config/config.php';
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

// Raccolta dati produzione per grafico (ultimi 7 giorni)
$produzioneData = $pdo->query("
    SELECT DATE(data_produzione) as giorno, COUNT(*) as totale
    FROM prodotti_composti
    GROUP BY giorno
    ORDER BY giorno DESC
    LIMIT 7
")->fetchAll(PDO::FETCH_ASSOC);

// Raccolta dati consumo materie prime
$consumoData = $pdo->query("
    SELECT pp.nome, SUM(r.quantita) as totale
    FROM ricette r
    JOIN prodotti_primari pp ON r.prodotto_primario_id = pp.id
    GROUP BY r.prodotto_primario_id
    ORDER BY totale DESC
    LIMIT 5
")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Statistiche Produzione</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
<header>
    <h1>Vape Balance Software</h1>
</header>
<nav>
    <a href="dashboard.php">Dashboard</a>
    <a href="prodotti_primari.php">Prodotti Primari</a>
    <a href="prodotti_composti.php">Prodotti Composti</a>
    <a href="carico.php">Carico</a>
    <a href="scarico.php">Scarico</a>
    <a href="ricette.php">Ricette</a>
    <a href="produzione.php">Produzione</a>
    <a href="report.php">Report</a>
    <a href="dashboard_stats.php">Statistiche</a>
    <a href="logout.php">Logout</a>
</nav>
<div class="container">
    <h2>Dashboard Statistica</h2>

    <canvas id="produzioneChart" width="600" height="300"></canvas>
    <canvas id="consumoChart" width="600" height="300"></canvas>

    <script>
    const produzioneCtx = document.getElementById('produzioneChart').getContext('2d');
    const produzioneChart = new Chart(produzioneCtx, {
        type: 'bar',
        data: {
            labels: <?= json_encode(array_column($produzioneData, 'giorno')) ?>,
            datasets: [{
                label: 'Produzione Giornaliera',
                data: <?= json_encode(array_column($produzioneData, 'totale')) ?>,
                backgroundColor: 'rgba(54, 162, 235, 0.6)'
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: { beginAtZero: true }
            }
        }
    });

    const consumoCtx = document.getElementById('consumoChart').getContext('2d');
    const consumoChart = new Chart(consumoCtx, {
        type: 'pie',
        data: {
            labels: <?= json_encode(array_column($consumoData, 'nome')) ?>,
            datasets: [{
                label: 'Consumo Ingredienti',
                data: <?= json_encode(array_column($consumoData, 'totale')) ?>,
                backgroundColor: [
                    'rgba(255, 99, 132, 0.6)',
                    'rgba(255, 206, 86, 0.6)',
                    'rgba(75, 192, 192, 0.6)',
                    'rgba(153, 102, 255, 0.6)',
                    'rgba(255, 159, 64, 0.6)'
                ]
            }]
        }
    });
    </script>
</div>
</body>
</html>
