
<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

$files = array_diff(scandir('../archivio'), ['.', '..']);
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Archivio Documenti PDF</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<header><h1>Archivio PDF</h1></header>
<nav>
    <a href="dashboard.php">Dashboard</a>
    <a href="archivio_pdf.php">Archivio PDF</a>
    <a href="logout.php">Logout</a>
</nav>
<div class="container">
    <h2>Documenti Salvati</h2>
    <ul>
        <?php foreach ($files as $file): ?>
            <li><a href="../archivio/<?= urlencode($file) ?>" download><?= $file ?></a></li>
        <?php endforeach; ?>
    </ul>
</div>
</body>
</html>
