
<?php
echo "<h2>🩺 Diagnostica Vape Balance Software</h2>";
echo "<pre>";

echo "✅ Avvio diagnostica...\n";

$config_path = __DIR__ . "/config/config.php";
if (file_exists($config_path)) {
    echo "✔️ config.php trovato\n";
    require_once $config_path;
} else {
    echo "❌ config.php NON trovato in /config/\n";
    exit;
}

echo "✔️ Test connessione database...\n";
try {
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll();
    echo "✔️ Connessione OK, tabelle trovate: " . count($tables) . "\n";
} catch (Exception $e) {
    echo "❌ Connessione DB fallita: " . $e->getMessage() . "\n";
    exit;
}

// Test funzione login
if (function_exists('login')) {
    echo "✔️ Funzione login() esiste\n";
    echo "🔐 Prova login con user: 'admin' / pass: 'admin'\n";
    $res = login('admin', 'admin');
    if ($res) {
        echo "✅ Login funzionante. Ruolo: " . $res['ruolo'] . "\n";
    } else {
        echo "⚠️ Login non riuscito (utente non trovato o password errata)\n";
    }
} else {
    echo "❌ Funzione login() MANCANTE in config.php\n";
}

echo "</pre>";
?>
