
<?php
require_once __DIR__ . '/../config/config.php';
session_start();

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

$where = [];
$params = [];

if (!empty($_GET['data'])) {
    $where[] = 'm.data_operazione = ?';
    $params[] = $_GET['data'];
}

if (!empty($_GET['tipo'])) {
    $where[] = 'm.tipo = ?';
    $params[] = $_GET['tipo'];
}

if (!empty($_GET['prodotto_id'])) {
    $where[] = 'm.prodotto_id = ?';
    $params[] = $_GET['prodotto_id'];
}

$where_sql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

$stmt = $pdo->prepare("SELECT m.*, p.nome AS prodotto FROM movimenti m JOIN prodotti_primari p ON p.id = m.prodotto_id $where_sql ORDER BY m.data_operazione DESC");
$stmt->execute($params);
$movimenti = $stmt->fetchAll(PDO::FETCH_ASSOC);

$prodotti = getGiacenze();
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Report Movimenti</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<header>
    <h1>Vape Balance Software</h1>
</header>
<nav>
    <a href="dashboard.php">Dashboard</a>
    <a href="prodotti_primari.php">Prodotti Primari</a>
    <a href="prodotti_composti.php">Prodotti Composti</a>
    <a href="carico.php">Carico</a>
    <a href="scarico.php">Scarico</a>
    <a href="ricette.php">Ricette</a>
    <a href="produzione.php">Produzione</a>
    <a href="report.php">Report</a>
    <a href="logout.php">Logout</a>
</nav>
<div class="container">
    <h2>Filtri e Report di Produzione</h2>
    <form method="GET">
        <label>Data:
            <input type="date" name="data" value="<?= $_GET['data'] ?? '' ?>">
        </label>
        <label>Tipo:
            <select name="tipo">
                <option value="">Tutti</option>
                <option value="carico" <?= ($_GET['tipo'] ?? '') == 'carico' ? 'selected' : '' ?>>Carico</option>
                <option value="scarico" <?= ($_GET['tipo'] ?? '') == 'scarico' ? 'selected' : '' ?>>Scarico</option>
            </select>
        </label>
        <label>Prodotto:
            <select name="prodotto_id">
                <option value="">Tutti</option>
                <?php foreach ($prodotti as $p): ?>
                    <option value="<?= $p['id'] ?>" <?= ($_GET['prodotto_id'] ?? '') == $p['id'] ? 'selected' : '' ?>><?= $p['nome'] ?></option>
                <?php endforeach; ?>
            </select>
        </label>
        <button type="submit">Filtra</button>
    </form>

    <hr>
    <h3>Risultati</h3>
    <table border="1" cellpadding="5">
        <tr><th>Data</th><th>Prodotto</th><th>Tipo</th><th>Quantità</th><th>Note</th></tr>
        <?php foreach ($movimenti as $m): ?>
            <tr>
                <td><?= $m['data_operazione'] ?></td>
                <td><?= $m['prodotto'] ?></td>
                <td><?= $m['tipo'] ?></td>
                <td><?= $m['quantita'] ?></td>
                <td><?= $m['note'] ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
