
<?php
require_once __DIR__ . '/../config/config.php';

header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="registro_' . date('Ymd') . '.csv"');

$output = fopen('php://output', 'w');
fputcsv($output, ['ID', 'Prodotto', 'Tipo', 'Quantità', 'Data', 'Note']);

$stmt = $pdo->prepare("SELECT m.id, p.nome AS prodotto, m.tipo, m.quantita, m.data_operazione, m.note
                       FROM movimenti m
                       JOIN prodotti_primari p ON p.id = m.prodotto_id
                       WHERE m.data_operazione = CURDATE()");
$stmt->execute();
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($data as $row) {
    fputcsv($output, $row);
}
fclose($output);
?>
