
<?php
require_once __DIR__ . '/../config/config.php';
require_once '../includes/fpdf.php';

session_start();
if (!isset($_SESSION['user'])) {
    die("Accesso non autorizzato");
}

// Placeholder per demo
$composto = "Prodotto Dimostrativo";
$data = date("d/m/Y");
$quantita = 100;

header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="produzione_' . date("Ymd") . '.pdf"');

require('fpdf.php');
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',16);
$pdf->Cell(0,10,"Produzione - Vape Balance Software", 0, 1, 'C');
$pdf->Ln(10);
$pdf->SetFont('Arial','',12);
$pdf->Cell(0,10,"Data: $data", 0, 1);
$pdf->Cell(0,10,"Prodotto: $composto", 0, 1);
$pdf->Cell(0,10,"Quantità: $quantita pezzi", 0, 1);
$pdf->Ln(10);
$pdf->MultiCell(0, 10, "Ricetta: [inserire qui la lista degli ingredienti della ricetta]");
$pdf->Output();
?>
