
<?php
require_once __DIR__ . '/../config/config.php';
session_start();

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['prodotto_id'], $_POST['quantita'])) {
    caricaProdotto($_POST['prodotto_id'], $_POST['quantita']);
    $stmt = $pdo->prepare("INSERT INTO movimenti (prodotto_id, tipo, quantita, data_operazione) VALUES (?, 'carico', ?, CURDATE())");
    $stmt->execute([$_POST['prodotto_id'], $_POST['quantita']]);
    header('Location: carico.php');
    exit;
}

$prodotti = getGiacenze();
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Carico Prodotti</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<header>
    <h1>Vape Balance Software</h1>
</header>
<nav>
    <a href="dashboard.php">Dashboard</a>
    <a href="prodotti_primari.php">Prodotti Primari</a>
    <a href="prodotti_composti.php">Prodotti Composti</a>
    <a href="carico.php">Carico</a>
    <a href="scarico.php">Scarico</a>
    <a href="report.php">Report</a>
    <a href="logout.php">Logout</a>
</nav>
<div class="container">
    <h2>Carico Prodotti</h2>
    <form method="POST">
        <label>Prodotto:
            <select name="prodotto_id">
                <?php foreach ($prodotti as $p): ?>
                    <option value="<?= $p['id'] ?>"><?= $p['nome'] ?> (<?= $p['giacenza'] ?> <?= $p['unita_misura'] ?>)</option>
                <?php endforeach; ?>
            </select>
        </label>
        <label>Quantità: <input type="number" name="quantita" step="0.01" required></label>
        <button type="submit">Carica</button>
    </form>
</div>
</body>
</html>
